<?php get_header(); ?>

<section class="category-hero">
  <?php if (have_posts()):
    the_post(); ?>
    <div class="hero-card">
      <div class="hero-thumb">
        <?php the_post_thumbnail('large'); ?>
      </div>
      <div class="hero-details">
        <div class="meta">
          <p class="author_name">
            <i class="hgi hgi-stroke hgi-user-circle-02"></i>
            <?php
            $first = get_the_author_meta('first_name');
            $last = get_the_author_meta('last_name');
            echo esc_html(trim("$first $last"));
            ?>
          </p>
          <p class="date">
            <i class="hgi hgi-stroke hgi-clock-02"></i>
            <?php the_date(); ?>
          </p>
        </div>
        <h2><?php the_title(); ?></h2>
        <p class="excerpt-text"><?php echo get_the_excerpt(); ?></p>
        <a href="<?php the_permalink(); ?>" class="btn-primary">Citește articolul <i
            class="hgi hgi-stroke hgi-arrow-right-02"></i></a>
      </div>
    </div>
  <?php endif; ?>
</section>

<div class="filters container">
  <form method="get" id="postFilters" class="filters-form">
    <select name="order" onchange="document.getElementById('postFilters').submit();">
      <option value="desc" <?php selected($_GET['order'] ?? '', 'desc'); ?>>Cele mai recente</option>
      <option value="asc" <?php selected($_GET['order'] ?? '', 'asc'); ?>>Cele mai vechi</option>
    </select>

    <select name="sortby" onchange="document.getElementById('postFilters').submit();">
      <option value="date" <?php selected($_GET['sortby'] ?? '', 'date'); ?>>Ordonare implicită</option>
      <option value="popular" <?php selected($_GET['sortby'] ?? '', 'popular'); ?>>Cele mai populare</option>
      <option value="comments" <?php selected($_GET['sortby'] ?? '', 'comments'); ?>>Cele mai comentate</option>
    </select>
  </form>
</div>

<section class="post-grid container">
  <?php rewind_posts();
  while (have_posts()):
    the_post(); ?>
    <article class="post-card">
      <div class="card-header">
        <?php the_post_thumbnail('medium'); ?>
        <div class="meta">
          <p>
            <i class="hgi hgi-stroke hgi-clock-02"></i>
            <?php echo get_the_date(); ?>
          </p>
          <p class="card-category"><?php the_category(', '); ?></p>
        </div>
      </div>
      <h3><?php the_title(); ?></h3>
      <p class="excerpt"><?php echo wp_trim_words(get_the_excerpt(), 30); ?></p>
      <a href="<?php the_permalink(); ?>" class="btn-read">Citește postarea <i
          class="hgi hgi-stroke hgi-arrow-right-02"></i></a>
    </article>
  <?php endwhile; ?>
</section>

<div class="pagination container">
  <?php the_posts_pagination(); ?>
</div>

<!-- Newsletter CTA -->
<section class="newsletter-section">
  <div class="newsletter-text">
    <h4>Abonează-te la newsletter</h4>
    <p>Primește cele mai recente articole, povești și sfaturi direct în inbox-ul tău.
      <br />
      Nu rata nimic din ce e important!
    </p>
  </div>
  <?php echo do_shortcode('[newsletter_form]'); ?>
</section>

<?php get_footer(); ?>